/*
 * Decompiled with CFR 0.152.
 */
package appbot.ae2;

import appbot.ae2.ManaKey;
import appbot.ae2.ManaKeyType;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.me.storage.ExternalStorageFacade;
import appeng.parts.automation.HandlerStrategy;
import com.google.common.primitives.Ints;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.IManaCollector;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.common.block.tile.mana.TilePool;

public class ManaHandlerStrategy
extends HandlerStrategy<IManaReceiver, Object> {
    public static final ManaHandlerStrategy INSTANCE = new ManaHandlerStrategy();

    private ManaHandlerStrategy() {
        super(ManaKeyType.TYPE);
    }

    public ExternalStorageFacade getFacade(final IManaReceiver handler) {
        return new ExternalStorageFacade(){

            public int getSlots() {
                return 1;
            }

            public GenericStack getStackInSlot(int slot) {
                return new GenericStack(ManaKey.KEY, (long)handler.getCurrentMana());
            }

            public AEKeyType getKeyType() {
                return ManaKeyType.TYPE;
            }

            protected int insertExternal(AEKey what, int amount, Actionable mode) {
                return Ints.saturatedCast((long)ManaHandlerStrategy.this.insert(handler, what, (long)amount, mode));
            }

            protected int extractExternal(AEKey what, int amount, Actionable mode) {
                if (!(what instanceof ManaKey)) {
                    return 0;
                }
                if (mode == Actionable.MODULATE) {
                    int before = handler.getCurrentMana();
                    handler.receiveMana(-Ints.saturatedCast((long)amount));
                    return Math.max(0, before - handler.getCurrentMana());
                }
                return Math.min(amount, handler.getCurrentMana());
            }

            public boolean containsAnyFuzzy(Set<AEKey> keys) {
                if (handler.getCurrentMana() == 0) {
                    return false;
                }
                for (AEKey key : keys) {
                    if (!(key instanceof ManaKey)) continue;
                    return true;
                }
                return false;
            }

            public void getAvailableStacks(KeyCounter out) {
                int currentMana = handler.getCurrentMana();
                if (currentMana != 0) {
                    out.add(ManaKey.KEY, (long)currentMana);
                }
            }
        };
    }

    @Nullable
    public Object getStack(AEKey what, long amount) {
        return null;
    }

    public long insert(IManaReceiver handler, AEKey what, long amount, Actionable mode) {
        if (!(what instanceof ManaKey)) {
            return 0L;
        }
        if (mode == Actionable.MODULATE) {
            int before = handler.getCurrentMana();
            handler.receiveMana(Ints.saturatedCast((long)amount));
            return Math.max(0, handler.getCurrentMana() - before);
        }
        int space = 0;
        if (handler instanceof TilePool) {
            TilePool pool = (TilePool)handler;
            space += pool.getAvailableSpaceForMana();
        } else if (handler instanceof ISparkAttachable) {
            ISparkAttachable sparkAttachable = (ISparkAttachable)handler;
            space += sparkAttachable.getAvailableSpaceForMana();
        } else if (handler instanceof IManaCollector) {
            IManaCollector collector = (IManaCollector)handler;
            space += collector.getMaxMana() - handler.getCurrentMana();
        } else if (!handler.isFull()) {
            space += 1000;
        }
        return Math.min(amount, (long)space);
    }
}

